/*
 * ReaderEntry.h
 *
 *  Created on: 22.10.2009
 *      Author: stefan.detter
 */

#ifndef READERENTRY_H_
#define READERENTRY_H_

#include <QObject>
#include <QString>
#include <QMap>
#include <QVector>
#include <QTime>
#include <QDateTime>
#include <QStringList>
#include <QPixmap>
#include <QTimer>

#include "TreeItem.h"

#include "../../application/Reader.h"

#include <QrfeTraceModule>

#include <def.h>

class AntennaEntry;
class TagEntry;

class ReaderEntry : public TreeItem, QrfeTraceModule
{
	Q_OBJECT

	typedef enum
	{
		READER_ROW_HEADER = 0,
		READER_ROW_COMMON,
		READER_ROW_SerialNumber,
		READER_ROW_SerialNumberDec,
		READER_ROW_ReaderType,
		READER_ROW_ReaderModule,
		READER_ROW_AntennaCount,
		READER_ROW_DeviceName,
		READER_ROW_HWRev,
		READER_ROW_SWRev,
		READER_ROW_BLRev,
		READER_ROW_TagType,
		READER_ROW_System,
		READER_ROW_Action,
		READER_ROW_State,
		READER_ROW_StatusRegister,
		READER_ROW_GPIOPins,
		READER_ROW_AttachedTime,
		READER_ROW_APPLICATION,
		READER_ROW_Name,
		READER_ROW_Location,
		READER_ROW_CURRENTREAD,
		READER_ROW_DifferentTags,
		READER_ROW_ReadCount,
		READER_ROW_ReadRate,
		READER_ROW_MaxReadRate,
		READER_ROW_DYNAMIC_INFO,
	} READER_INFORMATION_ROW_INDEX;

public:
	ReaderEntry(TreeItem* parent, Reader* r);
	virtual ~ReaderEntry();

private:
    void        readSignature();

public:
	QString					readerName() const;
	QString					readerId() const;
	QString					readerSerial() const;
	Reader* 				reader() const;

	QList<QString> 			tags() const;

	bool		isOffline();
	bool		isInventoryRunning();

	AntennaEntry* anntenna ( const uint antennaId ) const;
	AntennaEntry* appendAntenna ( const uint antennaId );

    int             tagCount() const;
    QSet<QString>   uniqueTagIds() const;
    TagEntry*       tag ( const QString& tagId ) const;
    TagEntry*       appendTag(const QString& type, const QString& tagId, const QString &visualTagId);

public slots:
	void		removeTag ( const QString& tagId );

public:
	virtual void		updateDynamicInfo();
	virtual void 		clearTags();

public slots:
	void heartBeat();
    void notification ( const uchar id, const QString& idStr, const QVariant& value);

	void tagTypeChanged();

	void readerChangedAction ( );
	void readerChangedState ( );
	void readerChangedStatusRegister ( );
	void readerChangedGpioValues( );

    void readerChangedSignature ( );
	void readerNameChanged( const QString& name );
	void readerLocationChanged( const QString& location );

	void changedRssiEnable(bool on, uchar rssiChildCount, const QStringList& rssiChildNames, int rssiChildMin, int rssiChildMax);
	void changedReadFrequencyEnable(bool on);

    void inventoryAboutToStart();
    void inventoryStarted();
	void inventoryStoped();
    void inventoryPaused();
    void inventoryContinued();

	void tagEvent(const TagEvent& event);

private slots:
	void heartBeatDisplayTimer();
    void removeAllChildren();

/****************************************************** Display functions */
public:
	virtual TYPE 		itemType ( ) const;
	virtual QVariant 	data ( int column, int role ) const;

	virtual int 		informationRowCount ( ) const;
	virtual QVariant	information ( int row, int column, int role ) const;

private:
	void 				prepareInformation ( );
private slots:
	void 				updateInformation ( );

protected:
	virtual QBrush 		headingBackgroundColor() const;

private:
	Reader* 					m_reader;
	QDateTime					m_attachedTime;
	bool						m_isOffline;
	QString 					m_readerId;

	bool 						m_usingAntennas;

	QList<AntennaEntry*>		m_antennaIndex;
	QMap<QString, TagEntry*>	m_tagIndex;

	bool						m_scanRunning;
    QTime						m_lastStarted;
	quint64						m_timeRunning;
	quint64						m_readTagCount;
	double						m_readRate;
	double 						m_maxReadRate;

	bool						m_rssiOn;
	QStringList					m_rssiChildNames;
	int							m_rssiChildMin;
	int							m_rssiChildMax;

	bool						m_readFrequencyOn;

    uint                        m_heartBeatCounter;
	QTimer*						m_heartBeatDisplayTimer;
	QPixmap*					m_onlineIcon;
	QPixmap						m_onlineUnboldIcon;
	QPixmap						m_onlineBoldIcon;
};

#endif /* READERENTRY_H_ */
